// GetMovie.java
// Version 0.43 
// Last Updated: 10/19/2000

// Change Log

package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import java.sql.*;

import Alkindi.BusinessDataTypes.*;
import Alkindi.BusinessServices.*;
import Alkindi.BusinessServices.Util.*;

public class GetMovie
{

	RatingMgrDBUtils rmdb = new RatingMgrDBUtils();

	// METHOD:	get_user_data
	// PURPOSE: 
	// INPUT:	SystemUser i_su
	// OUTPUT:	long a_movie_to_rate
	//
	public long get_user_data(SystemUser i_su, Vector pl) 
	throws AlkExcept {
			
		long amovie_to_rate =0;
		double[] w = new double[AlkParam.PARAM_NUM_PC];
		double[] b = new double[AlkParam.PARAM_NUM_PC];
		double[] E = new double[AlkParam.PARAM_NUM_PC];
		double[] R = new double[AlkParam.PARAM_NUM_PC];
		double[] F = new double[AlkParam.PARAM_NUM_PC];
		double[] Eave = new double[AlkParam.PARAM_NUM_PC];
		double[] Rave = new double[AlkParam.PARAM_NUM_PC];
		double[] n = new double[AlkParam.PARAM_NUM_PC];
		boolean useNullUserWeights = false;
		SystemUser i_cloneduser = i_su;
		if (i_su.id == 0) {
				useNullUserWeights = true;
		}
/*		if (i_su.id == 0)
		{
			i_cloneduser = new SystemUser(1000001); // 1000001 can be replaced by any existing user
 		}
*/		
		DataForPCList pcdataList = rmdb.GUD1(i_cloneduser);		
		//	If the user has no useful evaluation data, then
		//	there will be no entries in the list returned by 
		//	rmdb.GUD1. User null user to get ratings and
		//	set flag to use appropriate weights.
		//		 
//		if (pcdataList.size() == 0) {
//				SystemUser nullUser = new SystemUser(0);
//				pcdataList = rmdb.GUD1(nullUser);
//				useNullUserWeights = true;
//		}
		for (int j = 0; j < AlkParam.PARAM_NUM_PC; j++){
			UserDataStat uds = (UserDataStat)pcdataList.getByPCID(j+1);
			if (null == uds) throw new AlkExcept("get_user_data: uds is null", 2303);
	    	b[j] = uds.b;
			E[j] = uds.E; 
			R[j] = uds.R;
			F[j] = uds.F; 
			Eave[j] = uds.Eave; 
			Rave[j] = uds.Rave; 
			n[j] = uds.n;
			RM_new_Weights nW = new RM_new_Weights();
			//	Removed weight calculation to see if we can get it to work properly.
			//
//			if (useNullUserWeights) {
//				LogManager.dbgLog("GetMovie", "get_user_data", "Using null user weights.");
		
				w[j]= n[j];
//			}
//			else {
//				w[j] = nW.CalcWeight_user_data(n[j], AlkParam.PARAM_RAM_K, AlkParam.PARAM_RAM_A, R[j], Rave[j], AlkParam.PARAM_RAM_B, E[j], Eave[j], AlkParam.PARAM_RAM_C, F[j], b[j]);
//				LogManager.dbgLog("GetMovie", "get_user_data", "Calculated weights for product clusters.");
//			}
		}// for
		RandomStick RanS = new RandomStick();
		double Rk = Math.random();
		int selectedpc = RanS.RandomAccordingWeights(w, Rk) + 1;
		Vector Vgud2 = rmdb.GUD2(i_su, selectedpc);
		boolean tt = true;
		int i = 0;
		//LogManager.dbgLog("GetMovie:", "get_user_data", "Entering loop to check for existing products.");	
		//LogManager.dbgLog("GetMovie", "get_user_data", "GUD2 returned " + Vgud2.size() + " items for pcid=" + selectedpc);
/*					LogManager.dbgLog("GetMovie", "get_user_data", "Weights:");
		String dbgWts + "";
		for (int idx = 0; idx < AlkParam.PARAM_NUM_PC; idx ++) {
			dbgWts += "  " + w[idx]);
		}
		LogManager.dbgLog("GetMovie", "get_user_data", dbgWts);
*/		

		while ((tt == true) && i < (Vgud2.size())){
			amovie_to_rate = Long.parseLong((Vgud2.elementAt(i)).toString());
			tt = pl.contains(new Long(amovie_to_rate));
			i++;
		}
		//LogManager.dbgLog("GetMovie", "get_user_data", "Exiting get_user_data; returning movie_id=" + amovie_to_rate);
		return amovie_to_rate;		
	}

	
	// METHOD:	get_new_movie_data
	// PURPOSE: 
	// INPUT:	SystemUser i_su
	// OUTPUT:	long amovie_to_rate
	//
	public long get_new_movie_data(SystemUser i_su, Vector pl) 
	throws AlkExcept {
		long amovie_to_rate =0;
		double[] w = new double[AlkParam.PARAM_NUM_PC];
		double[] n = new double[AlkParam.PARAM_NUM_PC];
		double[] E = new double[AlkParam.PARAM_NUM_PC]; 
		DataForPCList pcdataList = rmdb.GNMD1(i_su);		
		for (int j = 0; j < AlkParam.PARAM_NUM_PC; j++){
			MovieData nmd = (MovieData)pcdataList.getByPCID(j+1);
			if (null == nmd) {
				throw new AlkExcept("get_new_movie_data: emd is null for j=" + j, 2302);
			}
	        n[j] = nmd.n;
			E[j] = nmd.E(); 
			RM_new_Weights nW = new RM_new_Weights();
			w[j] = n[j];//nW.CalcWeight(n[j], AlkParam.PARAM_RAM_K, AlkParam.PARAM_RAM_B, E[j]);
		}// for
		
		RandomStick RanS = new RandomStick();
		double Rk = Math.random();
		int selectedpc = RanS.RandomAccordingWeights(w, Rk) + 1;
		Vector Vgnmd2 = rmdb.GNMD2(i_su, selectedpc);
		Vector Vgnmd3 = rmdb.GNMD3(i_su, selectedpc);
		
		double u2 = AlkParam.PARAM_RAM_V - (AlkParam.PARAM_RAM_V - AlkParam.PARAM_RAM_U)*(Math.exp((-1)*AlkParam.PARAM_RAM_W*E[selectedpc - 1]));
		Bi_RandomStick BRS = new Bi_RandomStick();
		int k = BRS.Bi_Random(u2);
		boolean tt = true;	
		//System.out.println("get_new_movie_data: selected PC=" + selectedpc);
		//System.out.println("get_new_movie_data: Vgnmd2 size = " + Vgnmd2.size());
		//System.out.println("get_new_movie_data: Vgnmd3 size = " + Vgnmd3.size());
		//if k=1 choose from the popularlist else choose from unpopularlist
		//
		if (k == 1){
			while ((tt == true) && (Vgnmd2.size() > 0)){
				Random rnd = new Random();
				int d = rnd.nextInt(Vgnmd2.size());
//				System.out.println("get_new_movie_data: Attempting to get Vgnmd2 element " + d);
				amovie_to_rate = Long.parseLong((Vgnmd2.elementAt(d)).toString());
				Long aMovie = new Long(amovie_to_rate);
				tt = pl.contains(aMovie);
				if (tt) Vgnmd2.remove(aMovie); 
			}
		} //if
		
		else{
			while ((tt == true) && (Vgnmd3.size() > 0)){
				Random rnd = new Random();
				int d = rnd.nextInt(Vgnmd3.size());
				//System.out.println("get_new_movie_data: Attempting to get Vgnmd3 element " + d);
				amovie_to_rate = Long.parseLong((Vgnmd3.elementAt(d)).toString());
				Long aMovie = new Long(amovie_to_rate);
				tt = pl.contains(aMovie);
				if (tt) Vgnmd3.remove(aMovie);
			}
		} //else
		return amovie_to_rate;
	}

	// METHOD:	get_existing_movie_data
	// PURPOSE: 
	// INPUT:	SystemUser i_su, int omega, int delta, int gamma, Vector pl
	// OUTPUT:	long amovie_to_rate
	//
	public long get_existing_movie_data(SystemUser i_su, int omega, int delta, int gamma, Vector pl) 
	throws AlkExcept{
		long amovie_to_rate =0;
		double[] w = new double[AlkParam.PARAM_NUM_PC];
		double[] n = new double[AlkParam.PARAM_NUM_PC];
		double[] E = new double[AlkParam.PARAM_NUM_PC];
		DataForPCList pcdataList = rmdb.GEMD1(i_su);	
		for (int j = 0; j < AlkParam.PARAM_NUM_PC; j++){
			MovieData emd = (MovieData)pcdataList.getByPCID(j+1);
			if (null == emd) {
				throw new AlkExcept("get_existing_movie_data: emd is null for j=" + j, 2301);
			}
		   	n[j] = emd.n;
			E[j] = emd.E();
			RM_new_Weights nW = new RM_new_Weights();
			w[j] = n[j];//nW.CalcWeight(n[j], AlkParam.PARAM_RAM_K, AlkParam.PARAM_RAM_B, E[j]); 
		}// for
		
		RandomStick RanS = new RandomStick();
		double Rk = Math.random();
		int selectedpc = RanS.RandomAccordingWeights(w, Rk) + 1;
		int delta1 = delta + 1;
		Vector oldProds = rmdb.getOldProdByPC(i_su, selectedpc);
		boolean keepLooking = true;
		Long item = new Long(0);
		while (oldProds.size() > 0 && keepLooking) {
			item = (Long)oldProds.get(0);
			keepLooking = pl.contains(item);
			oldProds.remove(item);
		}
		if (keepLooking)
			return 0;
		else
			return item.longValue();
			
/*		Vector Vgemd2a = rmdb.GEMD2(i_su, selectedpc, omega, delta);
		Vector Vgemd2b = rmdb.GEMD2(i_su, selectedpc, delta1, gamma);
		Vector Vgemd3a = rmdb.GEMD3(i_su, selectedpc, omega, delta);
		Vector Vgemd3b = rmdb.GEMD3(i_su, selectedpc, delta1, gamma);
		double u2 = AlkParam.PARAM_RAM_U - (AlkParam.PARAM_RAM_V-AlkParam.PARAM_RAM_U)*(Math.exp((-1)*AlkParam.PARAM_RAM_W*E[selectedpc - 1]));
		Bi_RandomStick BRS = new Bi_RandomStick();
		int k = BRS.Bi_Random(u2);
		boolean tt = true;
		//if k=1 choose from the popularlist else choose from unpopularlist
		//
		/*
		if (k == 1){
			double p2 = AlkParam.PARAM_RAM_Kap*(Vgemd2b.size())/n[selectedpc - 1];
			int kk = BRS.Bi_Random(p2);
			while ((tt == true) && (Vgemd2a.size() > 0)){
				if (kk == 1){
					double frk = Math.random();
					int d = (int)(frk*(Math.abs((Vgemd2a.size() - 2))+1));
					amovie_to_rate = Long.parseLong((Vgemd2a.elementAt(d)).toString());
				}
				
				else{
					if (vgemd2b.size() != 0) 
					{
						double frk = math.random();
						int d = (int)(frk*(math.abs(vgemd2b.size() - 2)) + 1);
						amovie_to_rate = long.parselong((vgemd2b.elementat(d)).tostring());
					}
				}
				long amovie = new long(amovie_to_rate);
				tt = pl.contains(amovie);
				if (tt) vgemd2a.remove(amovie);
			}//end while
		} //if
		
		else{
			double p2 = AlkParam.PARAM_RAM_Kap*(Vgemd2b.size())/n[selectedpc - 1];
			int kk = BRS.Bi_Random(p2);
			
			while ((tt == true) && (Vgemd2a.size() != 0)){
				if (kk == 1){
					double frk = Math.random();
					int d = (int)(frk*(Math.abs(Vgemd2a.size()-2))+1);
					amovie_to_rate = Long.parseLong((Vgemd2a.elementAt(d)).toString());
				}
				
				else{    
					if (Vgemd2b.size() != 0)
					{
						double frk = Math.random();
						int d = (int)(frk*(Math.abs(Vgemd2b.size() - 2)) + 1);
						amovie_to_rate = Long.parseLong((Vgemd2b.elementAt(d)).toString());
					}
				}
				long amovie = new Long(amovie_to_rate);
				tt = pl.contains(amovie);
				if (tt) Vgemd2a.remove(amovie)
			}
		} //END else
		
		
		return amovie_to_rate; */
	}

}
